/**
 * @namespace desknet's NEO系アプリ共通処理
 */
var app = {};

/**
 * @namespace desknet's NEO系アプリ: 言語別リソース
 */
app.Resource = {
    "loadingText": "Loading...",
    "processingLabel": "Processing...",
    "rootLabel": "Root",
    "choosenItemCountLabel": "{{count}} item(s) are selected",

    "gender_male": "Male",
    "gender_female": "Female",
    "userLevel_admin": "System Administrator",
    "public_on": "Public",
    "public_off": "Private",

    "hours": "{{num}} hours",
    "days": "{{num}} day(s)",

    // 日時形式
    "listDateFormat": "MM/dd/yyyy", // 一覧用日付形式
    "listDateFormat_yearless": "MM/dd", // 一覧用日付形式(年省略)
    "listDateTimeFormat": "MM/dd/yyyy h:mm a", // 一覧用日時形式
    "listDateTimeFormat_yearless": "MM/dd h:mm a", // 一覧用日時形式(年省略)
    "detailDateFormat": "E MM/dd/yyyy", // 参照/設定用日付形式
    "detailDateTimeFormat": "E MM/dd/yyyy h:mm a", // 参照/設定用日時形式
    "calendarDateFormat": "E MM/dd/yyyy", // カレンダー用日付形式
    "calendarDateFormat_yearless": "E MM/dd", // カレンダー用日付形式(年省略)
    "yearFormat": "yyyy", // 年形式
    "monthFormat": "MMMM yyyy", // 年月形式
    "monthOnlyFormat": "MMMM", // 月形式
    "monthAndDayFormat": "MM/dd", // 月日形式
    "timeFormat": "h:mm a", // 時間形式

    "timeAmpm": "after" // 時間のAM/PMの位置
}

/**
 * フォーム文言
 */
app.Resource.form = {
    "invalidMissingMessage": "This field is mandatory.",
    "invalidEmailMismatchMessage": "Invalid format of email address.",
    "invalidUrlMismatchMessage": "URL format is invalid.",
    "invalidNumberMismatchMessage": "Invalid value.",
    "invalidNumberUnderflowMessage": "Please enter a value more than {{value}}.",
    "invalidNumberOverflowMessage": "Please enter a value less than {{value}}.",
    "invalidDateMismatchMessage": "Invalid date.",
    "invalidDateUnderflowMessage": "Please enter a date after {{value}}.",
    "invalidDateOverflowMessage": "Please enter a date before {{value}}.",
    "invalidImportFileMessage": "Please select the file(s) you want to import."
}

/**
 * ダイアログ文言
 */
app.Resource.dialog = {
    "errorTitle": "Error",
    "warnTitle": "Warning",
    "messageTitle": "Information",
    "addOkButtonLabel": "Add", // 追加ダイアログの肯定ボタン
    "createOkButtonLabel": "Create", // 作成ダイアログの肯定ボタン
    "updateOkButtonLabel": "Update", // 変更ダイアログの肯定ボタン
    "startToUpdateOkButtonLabel": "Update", // 変更ダイアログを開くボタン
    "saveButtonLabel": "Save as Draft" // 作成、変更ダイアログの下書きボタン
}

/**
 * レイアウト
 */
app.Resource.layout = {
    "openTitle": "Open",
    "closeTitle": "Close",
    "floatTitle": "Open afloat",
    "resizeWidthTitle": "Change width",
    "resizeHeightTitle": "Change height"
}

/**
 * ページ
 */
app.Resource.page = {
    "groupName_allUsers": "(All Users)",
    "groupName_notInGroup": "(Users Without Group)",
    "groupName_disused": "(Suspended Users)",
    "groupName_locked": "(Locked Accounts)",
    "groupName_deleted": "(Deleted)",
    "detailSearchTitle": "Advanced Search",
    "detailSearchSearchButton": "Search",
    "detailSearchClearButton": "Clear"
}

/**
 * 選択
 */
app.Resource.chooser = {
    "itemChooserTitle": "Select",
    "groupChooserTitle": "Select Group",
    "userChooserTitle": "User Select",
    "groupName_all": "(All)",
    "groupName_allUser": "(All Users)",
    "groupName_notInGroup": "(Users Without Group)",
    "chooseTarget_user": "Users",
    "chooseTarget_group": "Groups",
    "tabHeaderLabel_search": "Search",
    "tabHeaderLabel_group": "By Group",
    "tabHeaderLabel_history": "History",
    "history_linkLabel": "Display {{type}}"
}

/**
 * アップロード
 */
app.Resource.uploader = {
    "uploadingTitle": "Uploading...", // アップロード中ダイアログのタイトル  
    "chooseButtonLabel": neo.Resource.dialog.actionOkButtonLabel, // アップロードの決定ボタン(選択のみ)
    "uploadButtonLabel": "Upload", // アップロードの決定ボタン(すぐ送信)
    "abortButtonLabel": "Stop" // アップロードの中止ボタン
}

/**
 * カレンダー用
 */
app.Resource.calendar = {
    "glue": ", ",
    "allDay": "All Day",
    "termWithEndDate": "{{start_date:hs}} - {{end_date:hs}}",
    "termWithRepeat": "Repeat {{repeat_times:hs}} time(s) from {{start_date:hs}}",
    "interval_d": "Every {{interval:hs}} day(s)",
    "interval_d_every": "Daily",
    "interval_w": "Every {{interval:hs}} weeks on {{days_of_week:hs}}",
    "interval_w_every": "Weekly on {{days_of_week:hs}}",
    "interval_m": "Every {{interval:hs}} months on {{day_of_month:hs}}",
    "interval_m_every": "Monthly on {{day_of_month:hs}}",
    "interval_y": "Every {{interval:hs}} years",
    "interval_y_every": "Yearly",
    "dayOfMonthWithDay": "day {{day:hs}}",
    "dayOfMonthWithWeekAndDay": "the {{week:hs}} {{day_of_week:hs}}",
    "weeksOfMonth": ["last", "1st", "2nd", "3rd", "4th"],
    "RecurrenceEditorTitle": "Recurring Events",
    "DateChooserTitle": "Irregular Events",
    "monthCalendarHeader": ["Su","Mo","Tu","We","Th","Fr","Sa"], // 短い週の名前(日曜日から)、全角1文字まで
}

/**
 * ログイン
 */
app.Resource.sign = {
    "modifyPasswordTitle": "Change Password",
    "entryLicenseTitle": "License Settings"
}

/**
 * UI Datepickerのオプション
 */
app.Resource.datepickerOptions = {
    "nextText": "Next",
    "prevText": "Back",
    "currentText": "Today",
    "closeText": "Close",
    "dayNamesMin": app.Resource.calendar.monthCalendarHeader, // 曜日名(カレンダー用、全角1文字まで)
    "monthNames": neo.Resource.dateTime.longMonthes, // 月名(省略),
    "monthNamesShort": neo.Resource.dateTime.shortMonthes // 月名(省略)
}

/**
 * メッセージ
 */
app.Resource.Message = {
    "pageBeforeUnload": "Entered data has not been saved.",
    "pageBeforeNavigate": "Are you sure you want to leave this page?\nData you have entered may not be saved.",
    "dialogBeforeClose": "Are you sure you want to close this dialogue?\nData you have entered may not be saved.",

    "listConfirmToDelete": "Are you sure you want to delete the selected data?",
    "listTargetRequired": "Please choose the target item(s).",
    "listSortableItemsRequired": "Please choose the item(s) to you want to move.",
    "listConfirmToMove": "Are you sure you want to change the location of the selected item(s)?",
    "listDeleteItemsRequired": "Please choose the item(s) you want to delete.",

    "inputConfirmToDelete": "Are you sure you want to delete?",

    "uploadNameDuplicated": "「{{name}}」is already exist. Do you want to replace it?",
    "uploadIgnoreNonImage": "Only GIF, JPEG and PNG files can be chose. \nThe other format cannot be chosen.",
    "uploadIgnoreNonImage_single": "Please choose GIF, JPEG or PNG files.",
    "uploadIgnoreSizeOver": "Only files that less than {{size}} size can be chosen.\nFiles that exceed the limit cannot be chosen.",
    "uploadFileSizeOver": "Uploaded files exceed the limit size.<br>File size: ({{total}}) / limit file size: ({{max}})",

    "calendarDatesRequired": "Please choose a date.",

    "passwordTrialRest": "You have {{count}} attempts remaining before your account is locked",

    "importExecutionTitle": "Importing",
    "importUnderExecution": "Please wait awhile.",
    "importComplete": "Import completed",

    "treeConfirmToMove": "Are you sure you want to move {{count:hs}} selected data?<br>Move target: {{name}}",

    "licenseDueMessage": "You can use until {{due}}. (Remaining {{date}} day(s))",
    "evaluateLicenseMessage": "Thank you for evaluating our product. You are currently using an evaluation version.<br />",
    "expiredLicenseMessage": "The evaluation period has expired. Please obtain a license key to continue using this application.",
    "entryLicenseMessage": "Click <a href=\"#\" class=\"app-license-entry\">here</a> to add with the purchased [License key].",
    "exceedanceLicenseMessage": "{{count}}  license key(s) is/are insufficient.",
    "exceedanceNoExpireLicenseMessage": "Only {{limit}} user(s) are allowed to use this application. Please delete {{count}} user(s) or purchase the insufficient key(s)",
    "exceedanceExpireLicenseMessage": "Please purchase the insufficient license key(s).",
    "availableLicenseMessage": "{{count}} user license(s) are purchased."
}
